import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class Alfabeto {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        while (true) {
            // Entrada dos valores de k e n
            System.out.print("Digite k e n (0 0 para sair): ");
            int k = scanner.nextInt();
            int n = scanner.nextInt();
            scanner.nextLine(); // Consumir quebra de linha

            if (k == 0 && n == 0) {
                break;
            }

            // Entrada do alfabeto e da mensagem
            System.out.print("Digite o alfabeto permitido: ");
            String alphabet = scanner.nextLine();
            System.out.print("Digite a mensagem a ser verificada: ");
            String message = scanner.nextLine();

            // Validação
            if (validateMessage(alphabet, message)) {
                System.out.println("Sim");
            } else {
                System.out.println("Não");
            }
        }

        scanner.close();
    }

    public static boolean validateMessage(String alphabet, String message) {
        // Converte o alfabeto para um conjunto de caracteres
        Set<Character> alphabetSet = new HashSet<>();
        for (char c : alphabet.toCharArray()) {
            alphabetSet.add(c);
        }

        // Verifica se todos os caracteres da mensagem estão no conjunto
        for (char c : message.toCharArray()) {
            if (!alphabetSet.contains(c)) {
                return false;
            }
        }
        return true;
    }
}
